/**
 * Javascript for showing/hiding pages of content.
 *
 * @module     core/paged_content_pages
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core/paged_content_pages",["jquery","core/templates","core/notification","core/pubsub","core/paged_content_events","core/pending"],(function($,Templates,Notification,PubSub,PagedContentEvents,Pending){var SELECTORS_PAGE_REGION='[data-region="paged-content-page"]',TEMPLATES_PAGING_CONTENT_ITEM="core/paged_content_page",TEMPLATES_LOADING="core/overlay_loading",findPage=function(root,pageNumber){return root.find('[data-page="'+pageNumber+'"]')},showPages=function(root,pagesData,id,renderPagesContentCallback){var pendingPromise=new Pending("core/paged_content_pages:showPages"),existingPages=[],newPageData=[],newPagesPromise=$.Deferred();if(pagesData.forEach((function(pageData){var pageNumber=pageData.pageNumber,existingPage=findPage(root,pageNumber);existingPage.length?existingPages.push(existingPage):newPageData.push(pageData)})),newPageData.length&&"function"==typeof renderPagesContentCallback){var renderPagePromises=renderPagesContentCallback(newPageData,{allItemsLoaded:function(lastPageNumber){PubSub.publish(id+PagedContentEvents.ALL_ITEMS_LOADED,lastPageNumber)}}).map((function(promise,index){return function(root,pagePromise,pageNumber){var deferred=$.Deferred();return pagePromise.then((function(html,pageJS){pageJS=pageJS||"",Templates.render(TEMPLATES_PAGING_CONTENT_ITEM,{page:pageNumber,content:html}).then((function(html){Templates.appendNodeContents(root,html,pageJS);var page=findPage(root,pageNumber);deferred.resolve(page)})).fail((function(exception){deferred.reject(exception)})).fail(Notification.exception)})).fail((function(exception){deferred.reject(exception)})).fail(Notification.exception),deferred.promise()}(root,promise,newPageData[index].pageNumber)}));$.when.apply($,renderPagePromises).then((function(){var newPages=Array.prototype.slice.call(arguments);newPagesPromise.resolve(newPages)})).fail((function(exception){newPagesPromise.reject(exception)})).fail(Notification.exception)}else newPagesPromise.resolve([]);var loadingPromise=function(root){var deferred=$.Deferred();root.attr("aria-busy",!0);var pendingPromise=new Pending("core/paged_content_pages:startLoading");return Templates.render(TEMPLATES_LOADING,{visible:!0}).then((function(html){var loadingSpinner=$(html),timerId=setTimeout((function(){root.css("position","relative"),loadingSpinner.appendTo(root)}),300);deferred.always((function(){clearTimeout(timerId),loadingSpinner.remove(),root.css("position",""),root.removeAttr("aria-busy"),pendingPromise.resolve()}))})).fail(Notification.exception),deferred}(root);newPagesPromise.then((function(newPages){var pagesToShow=existingPages.concat(newPages);root.find(SELECTORS_PAGE_REGION).addClass("hidden"),pagesToShow.forEach((function(page){page.removeClass("hidden")}))})).then((function(){PubSub.publish(id+PagedContentEvents.PAGES_SHOWN,pagesData)})).fail(Notification.exception).always((function(){loadingPromise.resolve(),pendingPromise.resolve()})).catch()};return{init:function(root,id,renderPagesContentCallback){root=$(root),PubSub.subscribe(id+PagedContentEvents.SHOW_PAGES,(function(pagesData){showPages(root,pagesData,id,renderPagesContentCallback)})),PubSub.subscribe(id+PagedContentEvents.SET_ITEMS_PER_PAGE_LIMIT,(function(){root.empty()}))},rootSelector:'[data-region="page-container"]'}}));

//# sourceMappingURL=paged_content_pages.min.js.map