<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language strings.
 *
 * @package     factor_sms
 * @author      Peter Burnett <peterburnett@catalyst-au.net>
 * @copyright   Catalyst IT
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['action:manage'] = 'Manage mobile phone number';
$string['action:revoke'] = 'Remove mobile phone number';
$string['addnumber'] = 'Mobile number';
$string['clientnotfound'] = 'AWS service client not found. Client must be fully qualified classname e.g. \Aws\S3\S3Client.';
$string['editphonenumber'] = 'Edit phone number';
$string['editphonenumberinfo'] = 'If you didn\'t receive the code or entered the wrong number, please edit the number and try again.';
$string['errorsmssent'] = 'Error sending a SMS message containing your verification code.';
$string['error:emptyverification'] = 'Empty code. Try again.';
$string['error:wrongphonenumber'] = 'The phone number you provided is not in a valid format.';
$string['error:wrongverification'] = 'Wrong code. Try again.';
$string['info'] = 'Have a verification code sent to the mobile number you choose.';
$string['logindesc'] = 'SMS message containing a 6-digit code sent to mobile number {$a}';
$string['loginoption'] = 'Have a code sent to your mobile phone';
$string['loginskip'] = "I didn't receive a code";
$string['loginsubmit'] = 'Continue';
$string['managefactor'] = 'Manage SMS';
$string['managefactorbutton'] = 'Manage';
$string['manageinfo'] = 'You are using \'{$a}\' to authenticate.';
$string['notification:smsgatewaymigration'] = 'SMS settings have moved';
$string['notification:smsgatewaymigrationinfo'] = 'A new SMS subsystem is now available for managing and configuring all SMS-related functions. Your existing SMS configurations have been seamlessly migrated. You can find and manage them on the new <a href="{$a}">SMS Gateways page</a>.';
$string['logintitle'] = 'Enter the verification code sent to your mobile';
$string['phonehelp'] = 'Enter your mobile number (including country code) to receive a verification code.';
$string['pluginname'] = 'SMS mobile phone';
$string['privacy:metadata'] = 'The SMS mobile phone factor plugin does not store any personal data.';
$string['revokefactorconfirmation'] = 'Remove \'{$a}\' SMS?';
$string['settings:duration'] = 'Validity duration';
$string['settings:duration_help'] = 'The period of time that the code is valid.';
$string['settings:gateway'] = 'SMS gateway';
$string['settings:gateway_help'] = 'The SMS provider you wish to send messages via';
$string['settings:heading'] = 'Users will receive an SMS with 6-digit code during login, which they must enter to complete the login process.

Users will need to register their mobile phone number first.';
$string['settings:setupdesc'] = '<br><br>To use SMS as an authentication factor, you first need to <a href="{$a}">set up an SMS gateway</a>.';
$string['settings:smsgateway'] = 'SMS gateway';
$string['settings:smsgateway_help'] = 'Select a gateway from the list, or <a href="{$a}">create a new gateway</a>.';
$string['setupfactor'] = 'Set up SMS';
$string['setupfactorbutton'] = 'Set up';
$string['setupsubmitcode'] = 'Save';
$string['setupsubmitphone'] = 'Send code';
$string['smsstring'] = '{$a->code} is your {$a->fullname} one-time security code.

@{$a->url} #{$a->code}';
$string['summarycondition'] = 'Using an SMS one-time security code';

// Deprecated since Moodle 4.5.
$string['settings:countrycode'] = 'Country number code';
$string['settings:countrycode_help'] = 'The calling code without the leading + as a default if users do not enter an international number with a + prefix.

See this link for a list of calling codes: {$a}';
$string['settings:aws'] = 'AWS SNS';
$string['settings:aws:key'] = 'Key';
$string['settings:aws:key_help'] = 'Amazon API key credential.';
$string['settings:aws:region'] = 'Region';
$string['settings:aws:region_help'] = 'Amazon API gateway region.';
$string['settings:aws:secret'] = 'Secret';
$string['settings:aws:secret_help'] = 'Amazon API secret credential.';
$string['settings:aws:usecredchain'] = 'Find AWS credentials using the default credential provider chain';
$string['settings:gateway'] = 'SMS Gateway';
$string['settings:gateway_help'] = 'The SMS provider you wish to send messages via';
$string['errorawsconection'] = 'Error connecting to AWS server: {$a}';
$string['event:smssentdescription'] = 'The user with ID {$a->userid} was sent a verification code via SMS. Information: {$a->debuginfo}';
$string['event:smssent'] = 'SMS message sent.';
